/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.eap.cloudsdk.client;

import com.tplink.eap.cloudsdk.DNSResolver;
import com.tplink.eap.cloudsdk.LogCenter;
import com.tplink.eap.cloudsdk.client.CloudRequest;
import com.tplink.eap.cloudsdk.client.CloudResponse;
import com.tplink.eap.cloudsdk.client.ConnectionStatus;
import com.tplink.eap.cloudsdk.client.ConnectionType;
import com.tplink.eap.cloudsdk.client.HeartBeat;
import com.tplink.eap.cloudsdk.client.HelloCloud;
import com.tplink.eap.cloudsdk.client.HelloCloudDelegate;
import com.tplink.eap.cloudsdk.client.IPacketDispatch;
import com.tplink.eap.cloudsdk.client.IRequestDelegate;
import com.tplink.eap.cloudsdk.client.IResponseDelegate;
import com.tplink.eap.cloudsdk.client.Packet;
import com.tplink.eap.cloudsdk.client.Response;
import com.tplink.eap.cloudsdk.client.SSLClient;
import com.tplink.eap.cloudsdk.client.StopConnReason;
import com.tplink.eap.cloudsdk.util.TwoTuple;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import net.sf.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceClient
implements IPacketDispatch {
    private static final Logger logger = LoggerFactory.getLogger(ServiceClient.class);
    private static final String DEFAULT_SERVICE_SERVER_DOMAIN = "n-devs-smb.tplinkcloud.com";
    private static final int DEFAULT_SERVICE_SERVER_PORT = 443;
    private static final int DEFAULT_VALID_TIME_MS = 172800000;
    private static final int DEFAULT_HEART_BEAT_INTERVAL_MS = 235000;
    private String domain = "n-devs-smb.tplinkcloud.com";
    private int port = 443;
    private List<InetAddress> addressList = new ArrayList<InetAddress>();
    private int validTimeMs = 172800000;
    private volatile int heartbeatIntervalMs = 235000;
    private int reconnectTimeWaitMaxMs = 1024000;
    private int reconnectMaxTimes = 5;
    private int reconnectRandomTimeMinMs = 2000;
    private int reconnectRandomTimeMaxMs = 256000;
    private volatile int noaccountReconnectIntervalMs = 259200000;
    private final int requestTimeoutMs = 5000;
    private final int getResponseInterval = 100;
    private volatile SSLClient sslClient;
    private final int minMsgId = 1;
    private final int maxMsgId = 65535;
    private long expiredTime = System.currentTimeMillis() + (long)this.validTimeMs;
    private volatile ConnectionStatus connStatus = ConnectionStatus.DISCONNECTED_NORMAL;
    private int msgId = 1;
    private HelloCloud helloCloud;
    private NotifyEvent notifyEvent;
    private Map<Integer, CloudResponse> responseMap = new ConcurrentHashMap<Integer, CloudResponse>();
    private Map<String, CloudRequest> requestMap = new HashMap<String, CloudRequest>();
    private Thread expiredAsynRequestCleanThread;
    private Thread recvThread;
    private Thread heartBeatThread;

    public ServiceClient(HelloCloudDelegate helloCloudDelegate, Map<String, CloudRequest> requestMap) {
        this.helloCloud = new HelloCloud(helloCloudDelegate, HelloCloud.ClientType.SERVICE_CLIENT);
        this.notifyEvent = new NotifyEvent();
        if (requestMap != null) {
            this.requestMap.putAll(requestMap);
        }
    }

    public ConnectionStatus getConnStatus() {
        return this.connStatus;
    }

    public void setConnStatus(ConnectionStatus connStatus) {
        this.connStatus = connStatus;
    }

    public int getHeartbeatIntervalMs() {
        return this.heartbeatIntervalMs;
    }

    public void setHeartbeatIntervalMs(int heartbeatIntervalMs) {
        this.heartbeatIntervalMs = heartbeatIntervalMs;
    }

    public int getNoaccountReconnectIntervalMs() {
        return this.noaccountReconnectIntervalMs;
    }

    public void setNoaccountReconnectIntervalMs(int noaccountReconnectIntervalMs) {
        this.noaccountReconnectIntervalMs = noaccountReconnectIntervalMs;
    }

    public void restoreDefaultServerConfig() {
        this.domain = DEFAULT_SERVICE_SERVER_DOMAIN;
        this.port = 443;
        this.validTimeMs = 172800000;
        this.expiredTime = System.currentTimeMillis() + (long)this.validTimeMs;
        this.addressList.clear();
    }

    public void updateServerConfig(String domain, int port, int validTime) {
        this.domain = domain;
        this.port = port;
        this.validTimeMs = validTime * 1000;
        this.expiredTime = System.currentTimeMillis() + (long)this.validTimeMs;
        this.addressList.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispatch(Packet packet) throws IOException {
        JSONObject jsonData = packet.getJson();
        if (packet.checkPacket(jsonData).equals((Object)Packet.PacketType.REQUEST)) {
            JSONObject response;
            CloudRequest cloudRequest;
            if (logger.isDebugEnabled()) {
                if (LogCenter.getLogAll()) {
                    logger.debug("Cloud request is {}.", (Object)jsonData.toString());
                } else {
                    logger.debug("Method of cloud request is {}.", (Object)jsonData.optString("method"));
                }
            }
            String method = jsonData.getString("method");
            int msdId = jsonData.getInt("id");
            if (method.equals("notifyEvent")) {
                this.notifyEvent.onRequest(jsonData);
            }
            if ((cloudRequest = this.requestMap.get(method)) != null && cloudRequest.getDelegate() != null) {
                response = this.requestMap.get(method).getDelegate().onRequest(jsonData);
            } else {
                logger.warn("Cloud request '{}' is not handled, content is {}.", (Object)method, (Object)jsonData.toString());
                response = new JSONObject();
                response.put((Object)"error_code", (Object)0);
            }
            response.put((Object)"id", (Object)msdId);
            logger.debug("Device response of {} is {}.", (Object)method, (Object)response.toString());
            this.sslClient.send(packet.pack(response));
        } else if (packet.checkPacket(jsonData).equals((Object)Packet.PacketType.RESPONSE)) {
            logger.debug("Cloud response is {}.", (Object)jsonData.toString());
            int id = jsonData.getInt(Response.KEY_ID);
            Map<Integer, CloudResponse> map = this.responseMap;
            synchronized (map) {
                CloudResponse cloudRes = this.responseMap.get(id);
                if (cloudRes != null) {
                    if (cloudRes.getDelagate() != null) {
                        cloudRes.getDelagate().onResponse(jsonData);
                        this.responseMap.remove(id);
                    } else {
                        cloudRes.setResponse(jsonData);
                    }
                } else {
                    logger.warn("Response handling mode of request(id:{}) is already removed because of timeout or exception.", (Object)id);
                }
            }
        } else {
            logger.warn("Unhandled message.");
        }
    }

    public synchronized TwoTuple<Boolean, Boolean> autoConnect(ConnectionType connType) throws InterruptedException {
        boolean connected = false;
        boolean backstep = false;
        int reconnectTimes = 0;
        int reconnectWaitTimeMs = 0;
        logger.trace("ConnectionType is {}, Connected service host is {}, port is {}.", new Object[]{connType, this.domain, this.port});
        while (reconnectTimes < this.reconnectMaxTimes && !Thread.currentThread().isInterrupted()) {
            logger.debug("Connect service server({}) {} times.", (Object)this.domain, (Object)(reconnectTimes + 1));
            if (System.currentTimeMillis() > this.expiredTime) {
                backstep = true;
                break;
            }
            ++reconnectTimes;
            try {
                connected = this.connect(connType, true);
            }
            catch (IOException | NoSuchAlgorithmException e) {
                logger.info("Exception occurs when connecting service server:{}", (Object)e.toString());
                logger.debug(e.toString(), (Throwable)e);
                connected = false;
            }
            if (connected) {
                this.setConnStatus(ConnectionStatus.CONNECTED);
                connected = true;
                break;
            }
            if (this.helloCloud.getStopConnect().equals((Object)StopConnReason.RECONNECT_SEF)) {
                this.setConnStatus(ConnectionStatus.DISCONNECTED_NORMAL);
                backstep = true;
                break;
            }
            if (this.helloCloud.getReconnectTime() > 0L) {
                logger.trace("Reconnects service server after {} seconds.", (Object)this.helloCloud.getReconnectTime());
                this.setConnStatus(ConnectionStatus.DISCONNECTED_FORBIDDEN);
                connected = this.connectDuringWait(connType, this.helloCloud.getReconnectTime() * 1000L);
                if (connected) {
                    this.setConnStatus(ConnectionStatus.CONNECTED);
                    break;
                }
                this.setConnStatus(ConnectionStatus.DISCONNECTED_NORMAL);
                reconnectTimes = 0;
                reconnectWaitTimeMs = 0;
                continue;
            }
            this.setConnStatus(ConnectionStatus.DISCONNECTED_NORMAL);
            reconnectWaitTimeMs = reconnectWaitTimeMs > 0 ? reconnectWaitTimeMs * 2 : new Random().nextInt(this.reconnectRandomTimeMaxMs / 1000 - this.reconnectRandomTimeMinMs / 1000 + 1) * 1000 + this.reconnectRandomTimeMinMs;
            reconnectWaitTimeMs = Math.min(reconnectWaitTimeMs, this.reconnectTimeWaitMaxMs);
            if (reconnectTimes < this.reconnectMaxTimes) {
                logger.debug("reconnectWaitTimeMs is {}.", (Object)reconnectWaitTimeMs);
                connected = this.connectDuringWait(connType, reconnectWaitTimeMs);
                if (!connected) continue;
                this.setConnStatus(ConnectionStatus.CONNECTED);
                break;
            }
            backstep = true;
        }
        logger.info("The result of connection is {}.", (Object)connected);
        return new TwoTuple<Boolean, Boolean>(connected, backstep);
    }

    public synchronized void close() {
        logger.debug("Close service client.");
        this.notifyAll();
        this.clean();
        this.setConnStatus(ConnectionStatus.DISCONNECTED_NORMAL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TwoTuple<StopConnReason, Integer> parseClosedReason() {
        StopConnReason reason = StopConnReason.DEFAULT_NORMAL;
        Integer reconnectWaitingTime = 0;
        NotifyEvent notifyEvent = this.notifyEvent;
        synchronized (notifyEvent) {
            if (this.notifyEvent.isWaiting()) {
                reason = this.notifyEvent.getStopReason();
                reconnectWaitingTime = this.notifyEvent.getReconnectTime();
            }
            this.notifyEvent.reset();
        }
        return new TwoTuple<StopConnReason, Integer>(reason, reconnectWaitingTime * 1000);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JSONObject send(JSONObject request) throws InterruptedException, UnsupportedEncodingException, IOException {
        JSONObject response = null;
        int id = 0;
        try {
            id = this.send(request, null);
            long timeBegin = System.currentTimeMillis();
            while (System.currentTimeMillis() - timeBegin < 5000L) {
                Map<Integer, CloudResponse> map = this.responseMap;
                synchronized (map) {
                    if (this.responseMap.get(id) == null || !this.sslClient.isConnected()) {
                        response = new JSONObject();
                        response.put((Object)"error_code", (Object)-10000);
                        break;
                    }
                    if (this.responseMap.get(id).getResponse() != null) {
                        response = this.responseMap.get(id).getResponse();
                        break;
                    }
                }
                Thread.sleep(100L);
            }
            if (response == null) {
                response = new JSONObject();
                response.put((Object)"error_code", (Object)-20002);
            }
        }
        catch (Throwable throwable) {
            Map<Integer, CloudResponse> map = this.responseMap;
            synchronized (map) {
                this.responseMap.remove(id);
            }
            throw throwable;
        }
        Map<Integer, CloudResponse> map = this.responseMap;
        synchronized (map) {
            this.responseMap.remove(id);
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int send(JSONObject request, IResponseDelegate delegate) throws UnsupportedEncodingException, IOException {
        int id = 0;
        Map<Integer, CloudResponse> map = this.responseMap;
        synchronized (map) {
            id = this.addResponseMap(delegate);
            request.put((Object)"id", (Object)id);
            if (logger.isDebugEnabled()) {
                if (LogCenter.getLogAll()) {
                    logger.debug("Device request or response is {}.", (Object)request.toString());
                } else if (request.has("method")) {
                    logger.debug("Method of device request(id:{}) is {}.", (Object)id, (Object)request.optString("method"));
                } else {
                    logger.debug("Device response(id:{}) is {}.", (Object)id, (Object)request.toString());
                }
            }
            Packet pkt = new Packet();
            try {
                this.sslClient.send(pkt.pack(request));
            }
            catch (IOException e) {
                Map<Integer, CloudResponse> map2 = this.responseMap;
                synchronized (map2) {
                    this.responseMap.remove(id);
                }
                throw e;
            }
        }
        return id;
    }

    private boolean connect(ConnectionType connType, boolean timeoutRetry) throws IOException, InterruptedException, NoSuchAlgorithmException {
        JSONObject response;
        boolean connected = false;
        ConnectionStatus connStatus = this.getConnStatus();
        if (connStatus.equals((Object)ConnectionStatus.CONNECTED)) {
            return true;
        }
        this.setConnStatus(ConnectionStatus.CONNECTING);
        if (this.sslClient == null) {
            this.sslClient = new SSLClient(this.removeFirstAddress(), this.port);
        } else {
            this.sslClient.updateClient(this.removeFirstAddress(), this.port);
        }
        this.helloCloud.reset();
        this.sslClient.connect();
        this.createRecvThread(connType);
        int retry = 0;
        do {
            if (Thread.currentThread().isInterrupted()) {
                throw new InterruptedException("Interrupts the connection of service client.");
            }
            response = this.send(this.helloCloud.getRequest(0));
            this.helloCloud.onResponse(response);
            if (!timeoutRetry || response.getInt("error_code") != -20002 || ++retry >= 3) continue;
            Thread.sleep(5000L);
        } while (timeoutRetry && response.getInt("error_code") == -20002 && retry < 3);
        if (response.getInt("error_code") == 0 && this.helloCloud.getIllegalType() == 0 && this.helloCloud.getStopConnect().equals((Object)StopConnReason.DEFAULT_NORMAL)) {
            connected = true;
            this.createExpiredAsynRequestCleanThread();
            if (connType.equals((Object)ConnectionType.PERSISTENT_CONNECTION)) {
                this.createHeartBeatThread();
            }
        }
        return connected;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clean() {
        block18: {
            block17: {
                logger.debug("Clean the connection of service client.");
                try {
                    try {
                        if (this.sslClient != null) {
                            this.sslClient.close();
                        }
                        break block17;
                    }
                    catch (IOException e) {
                        logger.info(e.toString(), (Throwable)e);
                        this.stopHeartBeatThread();
                        this.stopExpiredAsynRequestCleanThread();
                        this.stopRecvThread();
                        this.msgId = 1;
                        Map<Integer, CloudResponse> map = this.responseMap;
                        synchronized (map) {
                            Iterator<Map.Entry<Integer, CloudResponse>> iterator = this.responseMap.entrySet().iterator();
                            while (iterator.hasNext()) {
                                Map.Entry<Integer, CloudResponse> entry = iterator.next();
                                if (entry.getValue().getDelagate() == null) continue;
                                JSONObject response = new JSONObject();
                                response.put((Object)"error_code", (Object)-10000);
                                entry.getValue().getDelagate().onResponse(response);
                                iterator.remove();
                            }
                            this.responseMap.clear();
                            break block18;
                        }
                    }
                }
                catch (Throwable throwable) {
                    this.stopHeartBeatThread();
                    this.stopExpiredAsynRequestCleanThread();
                    this.stopRecvThread();
                    this.msgId = 1;
                    Map<Integer, CloudResponse> map = this.responseMap;
                    synchronized (map) {
                        Iterator<Map.Entry<Integer, CloudResponse>> iterator = this.responseMap.entrySet().iterator();
                        while (iterator.hasNext()) {
                            Map.Entry<Integer, CloudResponse> entry = iterator.next();
                            if (entry.getValue().getDelagate() == null) continue;
                            JSONObject response = new JSONObject();
                            response.put((Object)"error_code", (Object)-10000);
                            entry.getValue().getDelagate().onResponse(response);
                            iterator.remove();
                        }
                        this.responseMap.clear();
                    }
                }
                throw throwable;
            }
            this.stopHeartBeatThread();
            this.stopExpiredAsynRequestCleanThread();
            this.stopRecvThread();
            this.msgId = 1;
            Map<Integer, CloudResponse> map = this.responseMap;
            synchronized (map) {
                Iterator<Map.Entry<Integer, CloudResponse>> iterator = this.responseMap.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry<Integer, CloudResponse> entry = iterator.next();
                    if (entry.getValue().getDelagate() == null) continue;
                    JSONObject response = new JSONObject();
                    response.put((Object)"error_code", (Object)-10000);
                    entry.getValue().getDelagate().onResponse(response);
                    iterator.remove();
                }
                this.responseMap.clear();
            }
        }
    }

    private boolean connectDuringWait(ConnectionType connType, long waitTime) throws InterruptedException {
        boolean connected = false;
        long leftWaitTime = waitTime;
        long waitEndTime = System.currentTimeMillis() + leftWaitTime;
        do {
            this.clean();
            this.wait(leftWaitTime);
            leftWaitTime = waitEndTime - System.currentTimeMillis();
            if (leftWaitTime <= 0L) continue;
            try {
                if (System.currentTimeMillis() > this.expiredTime) {
                    this.restoreDefaultServerConfig();
                }
                ConnectionStatus status = this.getConnStatus();
                connected = this.connect(connType, false);
                if (connected) break;
                this.clean();
                this.setConnStatus(status);
            }
            catch (IOException | NoSuchAlgorithmException e) {
                logger.info(e.toString(), (Throwable)e);
                connected = false;
            }
        } while (leftWaitTime > 0L && !Thread.currentThread().isInterrupted());
        return connected;
    }

    private void createExpiredAsynRequestCleanThread() {
        this.expiredAsynRequestCleanThread = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                while (!ServiceClient.this.expiredAsynRequestCleanThread.isInterrupted()) {
                    long currentTime = System.currentTimeMillis();
                    Map map = ServiceClient.this.responseMap;
                    synchronized (map) {
                        Iterator iterator = ServiceClient.this.responseMap.entrySet().iterator();
                        while (iterator.hasNext()) {
                            Map.Entry entry = iterator.next();
                            if (((CloudResponse)entry.getValue()).getExpireTimeMs() >= currentTime || ((CloudResponse)entry.getValue()).getDelagate() == null) continue;
                            JSONObject response = new JSONObject();
                            response.put((Object)"error_code", (Object)-20002);
                            ((CloudResponse)entry.getValue()).getDelagate().onResponse(response);
                            iterator.remove();
                        }
                    }
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException e) {
                        logger.debug(e.toString(), (Throwable)e);
                        logger.info("expiredRequestCleanThread is interrupted.");
                        Thread.currentThread().interrupt();
                    }
                }
                logger.info("Thread 'expiredRequestCleanThread' is stopped");
            }
        });
        this.expiredAsynRequestCleanThread.start();
    }

    private void stopExpiredAsynRequestCleanThread() {
        if (this.expiredAsynRequestCleanThread != null && !this.expiredAsynRequestCleanThread.isInterrupted()) {
            this.expiredAsynRequestCleanThread.interrupt();
        }
    }

    private void createRecvThread(ConnectionType connType) {
        this.recvThread = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                logger.debug("Started recvThread's name is {}.", (Object)Thread.currentThread().getName());
                try {
                    ServiceClient.this.sslClient.recv(ServiceClient.this);
                }
                catch (SocketException e) {
                    logger.info("'recvThread' exception:{}", (Object)e.toString());
                    logger.debug(e.toString(), (Throwable)e);
                }
                catch (IOException e) {
                    logger.info(e.toString(), (Throwable)e);
                }
                logger.info("Thread 'recvThread' is stopped");
                ServiceClient serviceClient = ServiceClient.this;
                synchronized (serviceClient) {
                    if (Thread.currentThread() == ServiceClient.this.recvThread && ServiceClient.this.getConnStatus().equals((Object)ConnectionStatus.CONNECTED)) {
                        ServiceClient.this.setConnStatus(ConnectionStatus.DISCONNECTED_NORMAL);
                    }
                }
            }
        });
        this.recvThread.start();
    }

    private void stopRecvThread() {
        logger.debug("Stopped recvThread's name is {}.", this.recvThread != null ? this.recvThread.getName() : null);
    }

    private void createHeartBeatThread() {
        this.heartBeatThread = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                HeartBeat heartBeat = new HeartBeat();
                try {
                    while (true) {
                        JSONObject response;
                        int retry = 0;
                        do {
                            if ((response = ServiceClient.this.send(heartBeat.getRequest())).getInt("error_code") != -20002 || ++retry >= 3) continue;
                            Thread.sleep(5000L);
                        } while (response.getInt("error_code") == -20002 && retry < 3);
                        if (response.getInt("error_code") == 0) {
                            Thread.sleep(ServiceClient.this.getHeartbeatIntervalMs());
                            continue;
                        }
                        break;
                    }
                }
                catch (UnsupportedEncodingException e) {
                    logger.info(e.toString(), (Throwable)e);
                }
                catch (InterruptedException e) {
                    logger.debug(e.toString(), (Throwable)e);
                    logger.info("heartBeatThread is interrupted.");
                    Thread.currentThread().interrupt();
                }
                catch (IOException e) {
                    logger.info(e.toString(), (Throwable)e);
                }
                logger.debug("Thread 'heartBeatThread' is stopped");
                ServiceClient serviceClient = ServiceClient.this;
                synchronized (serviceClient) {
                    ServiceClient.this.notifyAll();
                }
                logger.info("Thread 'heartBeatThread' is stopped");
            }
        });
        this.heartBeatThread.start();
    }

    private void stopHeartBeatThread() {
        if (this.heartBeatThread != null && !this.heartBeatThread.isInterrupted()) {
            this.heartBeatThread.interrupt();
        }
    }

    private void buildAddressList() throws UnknownHostException {
        Collections.addAll(this.addressList, DNSResolver.getAddresses(this.domain));
        Collections.shuffle(this.addressList);
    }

    private InetAddress removeFirstAddress() throws UnknownHostException {
        if (this.addressListIsEmpty()) {
            this.buildAddressList();
        }
        InetAddress address = this.addressList.remove(0);
        if (logger.isDebugEnabled()) {
            logger.debug("InetAddress of connected service server is {}.", (Object)address);
        }
        return address;
    }

    private boolean addressListIsEmpty() {
        return this.addressList.size() == 0;
    }

    private int generateMsgId() {
        if (this.msgId < 1 || this.msgId > 65535) {
            this.msgId = 1;
        }
        return this.msgId++;
    }

    private int addResponseMap(IResponseDelegate delegate) {
        int id = this.generateMsgId();
        this.responseMap.put(id, new CloudResponse(id, delegate));
        return id;
    }

    public class NotifyEvent
    implements IRequestDelegate {
        public static final String METHOD_NAME = "notifyEvent";
        public static final String KEY_EVENT = "event";
        public static final String KEY_ATTRIBUTE = "attribute";
        public static final String KEY_ILLEGAL_TYPE = "illegalType";
        public static final String KEY_RECONNECT_TIME = "reconnectTime";
        public static final String KEY_REASON = "reason";
        public static final String KEY_INTERVAL = "interval";
        public static final String EVENT_VAL_LEGAL_DEVICE = "legalDevice";
        public static final String EVENT_VAL_ILLEGAL_DEVICE = "illegalDevice";
        public static final String EVENT_VAL_STOP_CONNECT = "stopConnect";
        public static final String EVENT_VAL_HEART_BEAT_INTERVAL = "heartBeatInterval";
        public static final String EVENT_VAL_CONNECT_INTERVAL = "connectInterval";
        private boolean waiting = false;
        private int reconnectTime = 0;
        private StopConnReason stopReason = StopConnReason.DEFAULT_NORMAL;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public JSONObject onRequest(JSONObject request) {
            JSONObject params = request.getJSONObject("params");
            String event = params.getString(KEY_EVENT);
            JSONObject attribute = null;
            if (params.has(KEY_ATTRIBUTE)) {
                attribute = params.getJSONObject(KEY_ATTRIBUTE);
            }
            if (!event.equals(EVENT_VAL_LEGAL_DEVICE)) {
                if (event.equals(EVENT_VAL_ILLEGAL_DEVICE)) {
                    if (attribute.has(KEY_RECONNECT_TIME)) {
                        this.reconnectTime = attribute.getInt(KEY_RECONNECT_TIME);
                    }
                    if (this.reconnectTime <= 0) {
                        this.reconnectTime = new Random().nextInt(1023) + 2;
                    }
                    this.waiting = true;
                    ServiceClient serviceClient = ServiceClient.this;
                    synchronized (serviceClient) {
                        ServiceClient.this.notifyAll();
                    }
                } else if (event.equals(EVENT_VAL_STOP_CONNECT)) {
                    if (attribute.has(KEY_REASON)) {
                        this.stopReason = StopConnReason.valueOf(attribute.getInt(KEY_REASON));
                    }
                    if (attribute.has(KEY_RECONNECT_TIME)) {
                        this.reconnectTime = attribute.getInt(KEY_RECONNECT_TIME);
                    }
                    this.waiting = true;
                    ServiceClient serviceClient = ServiceClient.this;
                    synchronized (serviceClient) {
                        ServiceClient.this.notifyAll();
                    }
                } else if (event.equals(EVENT_VAL_HEART_BEAT_INTERVAL)) {
                    int interval;
                    int n = interval = attribute != null ? attribute.getInt(KEY_INTERVAL) : 0;
                    if (interval > 0) {
                        ServiceClient.this.setHeartbeatIntervalMs(interval * 1000);
                    }
                } else if (event.equals(EVENT_VAL_CONNECT_INTERVAL)) {
                    int interval;
                    int n = interval = attribute != null ? attribute.getInt(KEY_INTERVAL) : 0;
                    if (interval > 0) {
                        ServiceClient.this.setNoaccountReconnectIntervalMs(interval * 1000);
                    }
                } else {
                    logger.warn("Unhandled event({}) from cloud request 'notifyEvent'.", (Object)event);
                }
            }
            JSONObject response = new JSONObject();
            response.put((Object)"error_code", (Object)0);
            return response;
        }

        public void reset() {
            this.waiting = false;
            this.reconnectTime = 0;
            this.stopReason = StopConnReason.DEFAULT_NORMAL;
        }

        public boolean isWaiting() {
            return this.waiting;
        }

        public void setWaiting(boolean waiting) {
            this.waiting = waiting;
        }

        public int getReconnectTime() {
            return this.reconnectTime;
        }

        public void setReconnectTime(int reconnectTime) {
            this.reconnectTime = reconnectTime;
        }

        public StopConnReason getStopReason() {
            return this.stopReason;
        }

        public void setStopReason(StopConnReason stopReason) {
            this.stopReason = stopReason;
        }
    }
}

